#include <bits/stdc++.h>

#define ll long long

void knapsack(ll W, std::vector<ll>& w, std::vector<ll>& v, double sf)
{
    std::vector<std::vector<ll>> dp(w.size() + 1, std::vector<ll>(W + 1, 0));

    for(ll i = 0; i <= w.size(); i++)
    {
        for(ll j = 0; j <= W; j++)
        {
            if(i == 0 || j == 0)
                dp[i][j] = 0;
            else if(w[i - 1] <= j)
                dp[i][j] = std::max(dp[i - 1][j], dp[i - 1][j - w[i - 1]] + v[i - 1]);
            else
                dp[i][j] = dp[i - 1][j];
        }
    }
    
    ll r = dp[w.size()][W];
    ll w1 = W;
    std::vector<ll> items;

    for(ll i = w.size(); i > 0 && r > 0; i--)
    {
        if(r == dp[i - 1][w1])
            continue;
        else
        {
            items.push_back(i);
            r -= v[i - 1];
            w1 -= w[i - 1];
        }
    }

    std::sort(items.begin(), items.end());
    std::cout << items.size() << "\n";
    for(const ll& x : items)
        std::cout << x << " ";
}

int main()
{
    ll N, W;
    double ep;
    std::cin >> N >> W >> ep;
    
    std::vector<ll> w(N), v(N);
    for(ll i = 0; i < N; i++)
        std::cin >> w[i] >> v[i];

    ll t = 0;
    double sf = ((1 - ep) * (*std::max_element(v.begin(), v.end()))) / N;
    for(ll i = 0; i < N; i++)
    {
        v[i] = floor((double)v[i] / sf);
        t += v[i];
    }

    knapsack(t, w, v, sf);

    return 0;
}